module.exports = {
  apps: [{
    name: "backend",       // Name of your application
    script: "server.js",   // Entry point (your main server file)
    instances: 4,      // Uses all CPU cores (auto load-balancing)
    exec_mode: "cluster",  // Enables clustering (better performance)
    autorestart: true,     // Auto-restart if crashes
    watch: false,          // Disable auto-restart on file changes (for production)
    max_memory_restart: "1G",  // Restart if memory exceeds 1GB (adjust based on server RAM)
    env: {
      NODE_ENV: "production",  // Runs in production mode
      PORT: 3000,             // Default port (change if needed)
    },
    error_file: "./logs/error.log",  // PM2 error logs
    out_file: "./logs/output.log",   // PM2 output logs
    merge_logs: true,
    time: true,
  }]
};
